#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>


#define BGM_FILE	"th135_bgm_tmp.dat"
#define MAX_BGM		21

int bgmtable[MAX_BGM][3]={
	{0x0000002C, 0x001249F0, 0x012AA044},
	{0x013C5268, 0x000F2874, 0x015227F4},
	{0x02A20B74, 0x00056730, 0x0120EC60},
	{0x03D6448C, 0x002633B8, 0x0177E1A8},
	{0x0559E888, 0x000C6814, 0x01554710},
	{0x06C10A84, 0x0066668C, 0x01A5A484},
	{0x08787490, 0x001D110C, 0x0148AACC},
	{0x09D323A0, 0x000F9350, 0x014CEFB4},
	{0x0B2C2930, 0x000D9F70, 0x0150A210},
	{0x0C8FD104, 0x0025F1DC, 0x0157A40C},

	{0x0DFB7FB0, 0x001EDD24, 0x02C1A9C4},
	{0x10D0BFDC, 0x00000000, 0x007F5AC8},
	{0x11501AD0, 0x000C1800, 0x010E7E08},
	{0x126DDF28, 0x000761B8, 0x00B3A5BC},
	{0x1334A65C, 0x0007A11C, 0x00B3E514},
	{0x13FB8E24, 0x00188668, 0x00A18DEC},
	{0x14AACB18, 0x001AF044, 0x00545C40},
	{0x150E4980, 0x00095464, 0x00CB20E4},
	{0x15EC3A74, 0x00000000, 0x00C14FC8},
	{0x16AD8A68, 0x000DEA90, 0x004756DC},

	{0x1702F96C, 0x00000000, 0x00D858AC}
};

char bgmfile[MAX_BGM][50]={
	"01 tFa@` Colorful Path.wav",
	"02 CKXiCg.wav",
	"03 eƃnCJ.wav",
	"04 ̖VO@` Cosmic Mind.wav",
	"05 __b`.wav",
	"06 `@` True Administrator.wav",
	"07 H열V͓̉@` Candid Friend.wav",
	"08 ng}̗d.wav",
	"09 n̓b.wav",
	"10 z̓b.wav",

	"11 S̃G[V.wav",
	"12 oEsς̃yV~Y.wav",
	"13 SYOq.wav",
	"14 lĈꏊ.wav",
	"15 lĈȂꏊ.wav",
	"16 NO̗.wav",
	"17 {̈ʋL.wav",
	"18 ŉ_.wav",
	"19 V.wav",
	"20 {̈ʋLiCgȂj.wav",

	"21 SYOqiX^bt[j.wav"
};

void makeheader(char *header,int datasize){
	int i;
	short s;
	memcpy(header,"RIFF",4);
	i = datasize + 36;
	memcpy(header+4,&i,4);
	memcpy(header+8,"WAVEfmt ",8);
	i = 16;
	memcpy(header+16,&i,4);
	s = 1;
	memcpy(header+20,&s,2);
	s = 2;
	memcpy(header+22,&s,2);
	i = 44100;
	memcpy(header+24,&i,4);
	i = 176400;
	memcpy(header+28,&i,4);
	s = 4;
	memcpy(header+32,&s,2);
	s = 16;
	memcpy(header+34,&s,2);
	memcpy(header+36,"data",4);
	i = datasize;
	memcpy(header+40,&i,4);

}

int main(int argc,char *argv[]){
	FILE *datf,*bgmf;
	int i,j,l,k;
	int rep=2;
	int length;
	int fade=0;
	int fadep=0;
	int ts=0;
	int te=MAX_BGM;
	char header[44];
	short buf[44100*2];
	int s,e;
	double d;


	//bgmtable(JnAJԂn_܂ł̒AI_܂ł̒)Ȃ̂
	//ꂼʒuɊZ
	for(i=0;i<MAX_BGM;i++){
		bgmtable[i][1]+=bgmtable[i][0];
		bgmtable[i][2]+=bgmtable[i][0];
	}

	//argc̃`FbN
	for(i=1;i<argc;i++){
		switch(argv[i][0]){
		case 'f' :
			argv[i]++; fade=atoi(argv[i]); break;
		case 'F' :
			argv[i]++; fade=-atoi(argv[i]); break;
		case 'P' :
		case 'p' :
			argv[i]++; fadep=atoi(argv[i]); break;
		case 'T' :
		case 't' :
			argv[i]++; ts=te=atoi(argv[i]); break;
		default:
			rep=atoi(argv[i]);
		}
	}

	if(rep<1 || rep>10){
		printf("repeat must be 1-10\n");
		return 0;
	}
	if(fade<-30 || fade>30){
		printf("fade must be 0-30\n");
		return 0;
	}
	if(fadep<0 || fadep>3){
		printf("fade pattern must be 0-3\n");
		return 0;
	}
	if(ts<0 || te>MAX_BGM){
		printf("track number must be 1-%d\n", MAX_BGM);
		return 0;
	}


	printf("track=%d-%d , repeat=%d , fade=%d , fade pattern=%d\n",ts+1,te,rep,fade,fadep);
	if(ts) ts--;

	datf=fopen(BGM_FILE,"rb");
	if(datf==NULL){
		printf("%s not found.", BGM_FILE);
		return 0;
	}

	//Jn
	for(i=ts;i<te;i++){

		printf("Create %s ...\n",bgmfile[i]);
		bgmf=fopen(bgmfile[i],"wb");
		length=(bgmtable[i][2]-bgmtable[i][0])+(bgmtable[i][2]-bgmtable[i][1])*(rep-1);
		if(fade<0) length+=(-fade)*44100*4;
		makeheader(header,length);
		fwrite(header,1,44,bgmf);

		//[v
		for(k=0;k<rep;k++){
			//[
			s=bgmtable[i][1];
			if(k==0) s=bgmtable[i][0];

			//I[
			e=bgmtable[i][2];
			if(k==rep-1 && fade>0) e=bgmtable[i][2]-fade*44100*4;

			for(j=s;j<e;j+=44100*4){
				if(j+44100*4>e) l=e-j;
				else l=44100*4;

				fseek(datf,j,SEEK_SET);
				fread(buf,1,l,datf);
				fwrite(buf,1,l,bgmf);
			}
		}

		//tF[hAEg
		if(fade>0){
			//[vI[
			s=bgmtable[i][2]-fade*44100*4;
			e=bgmtable[i][2];
		}
		else if(fade<0){
			//[v[
			s=bgmtable[i][1];
			e=s-fade*44100*4;
		}
		else{
			s=e=0;
		}

		for(j=s;j<e;j+=44100*4){
			if(j+44100*4>e) l=e-j;
			else l=44100*4;

			fseek(datf,j,SEEK_SET);
			fread(buf,1,l,datf);
			for(k=0;k<l/4;k++){
				switch (fadep) {
				case 0 :
					d=(float)((j-s)/4+k)/(abs(fade)*44100);
					d=pow(0.001,d);
					break;
				case 1 :
					d=1-(float)((j-s)/4+k)/(abs(fade)*44100);
					break;
				case 2 :
					d=(float)((j-s)/4+k)/(abs(fade)*44100);
					d=(pow(0.001,d)+(1-d))/2;
					break;
				case 3 :
					d=(cos(3.1415926535*(float)((j-s)/4+k)/(abs(fade)*44100))+1)/2;
					break;
				}

				buf[2*k]=(short)(buf[2*k]*d);
				buf[2*k+1]=(short)(buf[2*k+1]*d);
			}
			fwrite(buf,1,l,bgmf);
		}

		fclose(bgmf);
	}
	fclose(datf);

	return 0;
}
